/*
Gidon Moont
1997-2000

Biomolecular Modelling Laboratory
Imperial Cancer Research Fund
44 Lincoln's Inn Fields
London WC2A 3PX

+44 (0)20 7269 3565
http://www.bmm.icnet.uk/

*/

#include "structures.h"

/************/

int gord( float position , float grid_span , int grid_size ) {

  int ordinate ;

  float one_span = grid_span / (float)grid_size ;

  ordinate = (int)( position / one_span ) + ( grid_size / 2 ) ;

  if( position < 0 ) ordinate -= 1 ;

  return ordinate ;

}

/************/

float pythagoras( float x1 , float y1 , float z1 , float x2 , float y2 , float z2 ) {

  return sqrt( ( ( x1 - x2 ) * ( x1 - x2 ) ) + ( ( y1 - y2 ) * ( y1 - y2 ) ) + ( ( z1 - z2 ) * ( z1 - z2 ) ) ) ;

}
