/*
Gidon Moont
1997-2000

Biomolecular Modelling Laboratory
Imperial Cancer Research Fund
44 Lincoln's Inn Fields
London WC2A 3PX

+44 (0)20 7269 3565
http://www.bmm.icnet.uk/

*/

#include "structures.h"

/* Copied from generalised version in Kernighan and Ritchie */

/************/

int numerical_sort( const void *a , const void *b ){
  return a > b ;
}

/************/

void qsort_scores( struct Score *Scores , int left , int right ) {

  /* Variables */

  int	i , last ;

  /* Sub function */

  void swap( struct Score *Scores , int i , int j ) ;


  /* Neat code */

  if( left >= right ) return ;	/* have nothing to sort */

  swap( Scores , left , ( left + right ) / 2 ) ;

  last = left ;

  for( i = left + 1 ; i <= right ; i ++ ) {

    if( Scores[i].score > Scores[left].score ) {

      swap( Scores , ++ last , i ) ;

    } else {

      if( Scores[i].score == Scores[left].score ) {

        if( Scores[i].coord[1] > Scores[left].coord[1] ) {

          swap( Scores , ++ last , i ) ;

        } else {

          if( Scores[i].coord[1] == Scores[left].coord[1] ) {

            if( Scores[i].coord[2] > Scores[left].coord[2] ) {

              swap( Scores , ++ last , i ) ;

            } else {

              if( Scores[i].coord[2] == Scores[left].coord[2] ) {

                if( Scores[i].coord[3] > Scores[left].coord[3] ) {

                  swap( Scores , ++ last , i ) ;

                } else {

                  if( Scores[i].coord[3] == Scores[left].coord[3] ) {

                    if( Scores[i].angle[1] > Scores[left].angle[1] ) {

                      swap( Scores , ++ last , i ) ;

                    } else {

                      if( Scores[i].angle[1] == Scores[left].angle[1] ) {

                        if( Scores[i].angle[2] > Scores[left].angle[2] ) {

                          swap( Scores , ++ last , i ) ;

                        } else {

                          if( Scores[i].angle[2] == Scores[left].angle[2] ) {

                            if( Scores[i].angle[3] > Scores[left].angle[3] ) {

                              swap( Scores , ++ last , i ) ;

                            }

                          }

                        }

                      }

                    }

                  }

                }

              }

            }

          }

        }

      }

    }

  }

  swap( Scores , left , last ) ;

  qsort_scores( Scores , left , last - 1 ) ;

  qsort_scores( Scores , last + 1 , right ) ;

}

/************/

void qsort_rpscores( struct Score *Scores , int left , int right ) {

  /* Variables */

  int	i , last ;

  /* Sub function */

  void swap( struct Score *Scores , int i , int j ) ;


  /* Neat code */

  if( left >= right ) return ;	/* have nothing to sort */

  swap( Scores , left , ( left + right ) / 2 ) ;

  last = left ;

  for( i = left + 1 ; i <= right ; i ++ )

    if( Scores[i].rpscore > Scores[left].rpscore ) 

       swap( Scores , ++ last , i ) ;

  swap( Scores , left , last ) ;

  qsort_rpscores( Scores , left , last - 1 ) ;

  qsort_rpscores( Scores , last + 1 , right ) ;

}

/************/

void swap( struct Score *Scores , int i , int j ) {

  struct Score	Temp ;

  Temp = Scores[i] ;
  Scores[i] = Scores[j] ;
  Scores[j] = Temp ;

}
