#!/usr/bin/perl -w

# Gidon Moont
# 2000

# Biomolecular Modelling Laboratory
# Imperial Cancer Research Fund
# 44 Lincoln's Inn Fields
# London WC2A 3PX

# +44 (0)20 7269 3565
# http://www.bmm.icnet.uk/

# Perl script to run Multidock

select STDOUT ;
$| = 1 ;

#############
#
# Other programs and files used by this one

BEGIN{

  $full_program_name = $0 ;
  ( $relative_path ) = ( $full_program_name =~ /^(.+)\/.+$/ ) ;

}

#############
#
# Command line options

my $pdb_in = 'undefined' ;
my $pdb_out = 'undefined' ;
my $params = 'params.dat' ;

while( @ARGV ) {

  my $bit = shift @ARGV ;

  if( $bit eq '-in' ) {
    $pdb_in = shift @ARGV ;
  }

  if( $bit eq '-out' ) {
    $pdb_out = shift @ARGV ;
  }

  if( $bit eq '-params' ) {
    $params = shift @ARGV ;
  }

}

print STDOUT "\nRunning MULTIDOCK\n" ;

print STDOUT "pdb input    :: ".$pdb_in."\n" ;
print STDOUT "pdb output   :: ".$pdb_out."\n" ;
print STDOUT "paramters    :: ".$params."\n" ;

$static_chains = `more static_1.parsed | cut -c22 | sort | uniq` ;
$mobile_chains = `more mobile_1.parsed | cut -c22 | sort | uniq` ;

$static_chains =~ s/\ //g ;
$static_chains =~ s/\n//g ;
$mobile_chains =~ s/\ //g ;
$mobile_chains =~ s/\n//g ;

open( Params , "> params.dat" ) or die ;
$i = 0 ;
for( $j = 1 ; $j <= length( $static_chains ) ; $j ++ ) {
  $i ++ ;
  printf( Params "imobile_mol=${i}\n" ) ;
}
for( $j = 1 ; $j <= length( $mobile_chains ) ; $j ++ ) {
  $i ++ ;
  printf( Params "mobile_mol=${i}\n" ) ;
}
printf( Params "temp= 298.0\n" ) ;
printf( Params "cut_jface= 20.0\n" ) ;
printf( Params "cut_iface= 10.0\n" ) ;
printf( Params "cut_atom_nb= 10.0\n" ) ;
printf( Params "cut_res_nb=15.0\n" ) ;
printf( Params "cut_lface=15.0\n" ) ;
printf( Params "ftol = 0.0001\n" ) ;
printf( Params "dielectric= 4.0\n" ) ;
printf( Params "eatmax= 2.5\n" ) ;
printf( Params "emax=0.4\n" ) ;
close( Params ) ;

print STDOUT "\n" ;
system "/bin/rm -f PDB PDB1 PDB2 PDBtor TOR.DAT INTERNAL.DAT" ;

die " *** ERROR: unable to assign AATOR.DAT file ***" unless -e "$relative_path/AATOR.DAT" ;
die " *** ERROR: unable to assign ROT.LIB file ***" unless -e "$relative_path/ROT.LIB" ;
die " *** ERROR: unable to assign ROT.OCC file ***" unless -e "$relative_path/ROT.OCC" ;

print STDOUT "\nGenerating sidechain multilple copies\n" ;
system "${relative_path}/mcopy $pdb_in PDB $params ${relative_path}/AATOR.DAT ${relative_path}/ROT.LIB" ;

print STDOUT "\nGenerating hydrogen atoms using PREPI\n" ;
system "${relative_path}/hydtor -iPDB -oPDB1 -d${relative_path}/HYDROGENS.DAT -random > ${pdb_out}.genhyd" ;

print STDOUT "\nRearranging the format of file generated by PREPI\n" ;
system "${relative_path}/rearrange PDB1 PDB2" ;

# Calculate the internal energies of rotomers from their observed population
#
print STDOUT "\nCalculating rotomer internal energies\n" ;
system "${relative_path}/torpdb PDB2 PDBtor" ;

# Calculating torsion angles using PREPI
#
system "${relative_path}/hydtor -iPDBtor -oTOR.DAT -tor > ${pdb_out}.tor" ;
system "${relative_path}/rotenergy TOR.DAT INTERNAL.DAT ${relative_path}/ROT.OCC" ;

# Running ensemble optimisation algorithm
#
print STDOUT "\nRunning ensemble optimisation algorithm\n" ;
system "time ${relative_path}/multidock_main PDB2 $pdb_out ${pdb_out}.out $params INTERNAL.DAT" ;

#############
#############

# Remerging output with input to form a correctly parsed PDB file

# hash table the input's records, using the unique string of
# atom type, residue type, chain ID and residue sequence number as the key

%atom_records = () ;

open( In  , $pdb_in ) or die ;
open( Static  , "> static_part.pdb" ) or die ;
open( Mobile  , "> mobile_part.pdb" ) or die ;
while( defined( $input_record = <In> ) ) {
  next unless( $input_record =~ /^ATOM/ ) ;
  $atom_records{substr( $input_record , 12 , 15 )} = $input_record ;
  $chain = substr( $input_record , 21 , 1 ) ;
  if( $static_chains =~ /$chain/ ) {
    print Static $input_record ;
  } else {
    print Mobile $input_record ;
  }
}
close( In ) ;
close( Static ) ;
close( Mobile ) ;

#############
#
# overwrite the hash table with the output's records (where they exist),
# first sorting out some things

%static_zones = () ;
%mobile_zones = () ;
open( Out , $pdb_out ) or die ;
open( Static  , "> static_output.pdb" ) or die ;
open( Mobile  , "> mobile_output.pdb" ) or die ;
while( defined( $output_record = <Out> ) ) {
  next unless( $output_record =~ /^ATOM/ ) ;
  next if( substr( $output_record , 12 , 4 ) eq ' HN ' ) ;
  $output_record =~ s/CYX/CYS/ ; 

  # what the f*** has Richard done? - seems to put a '1' in column after chainID if altLoc was originally flagged.
  # then all altLocs are flagged - bloody marvelous
  if( substr( $output_record , 22 , 1 ) eq ' ' ) {
    substr( $output_record , 26 , 1 ) = ' ' ;
  } else {
    substr( $output_record , 22 , 1 ) = ' ' ;
    if( substr( $output_record , 23 , 1 ) eq '0' ) {
      substr( $output_record , 23 , 1 ) = ' ' ;
    }
    if( substr( $output_record , 24 , 1 ) eq '0' ) {
      substr( $output_record , 24 , 1 ) = ' ' ;
    }
  }
  if( defined( $atom_records{substr( $output_record , 12 , 15 )} ) ) {
    $atom_records{substr( $output_record , 12 , 15 )} = $output_record ;
    $residue_number = substr( $output_record , 22 , 5 ) ;
    $chain = substr( $output_record , 21 , 1 ) ;
    $uid = $chain . $residue_number ;
    $uid =~ s/\ //g ;
    if( $static_chains =~ /$chain/ ) {
      print Static $output_record ;
      $static_zones{$uid} = 1 ;
    } else {
      print Mobile $output_record ;
      $mobile_zones{$uid} = 1 ;
    }
  }
}
close( Out ) ;
close( Static ) ;
close( Mobile ) ;

open( Profit , "> profit.com" ) or die ;

print Profit "REFERENCE static_output.pdb\n" ;
print Profit "MOBILE static_part.pdb\n" ;
print Profit "ATOMS CA\n" ;
print Profit "ZONE CLEAR\n" ;
print Profit "NUMBER RESIDUE\n" ;
foreach $zone ( keys %static_zones ) {
  print Profit "ZONE $zone-$zone\n" ;
}
print Profit "FIT\n" ;
print Profit "WRITE static_part_on_output.pdb\n" ;

print Profit "REFERENCE mobile_output.pdb\n" ;
print Profit "MOBILE mobile_part.pdb\n" ;
print Profit "ATOMS CA\n" ;
print Profit "ZONE CLEAR\n" ;
print Profit "NUMBER RESIDUE\n" ;
foreach $zone ( keys %mobile_zones ) {
  print Profit "ZONE $zone-$zone\n" ;
}
print Profit "FIT\n" ;
print Profit "WRITE mobile_part_on_output.pdb\n" ;

close( Profit ) ;

system "profit < profit.com" ;

#############

%atom_records = () ;

open( In  , "static_part_on_output.pdb" ) or die ;
while( defined( $input_record = <In> ) ) {
  next unless( $input_record =~ /^ATOM/ ) ;
  $atom_records{substr( $input_record , 12 , 15 )} = $input_record ;
}
close( In ) ;
open( In  , "mobile_part_on_output.pdb" ) or die ;
while( defined( $input_record = <In> ) ) {
  next unless( $input_record =~ /^ATOM/ ) ;
  $atom_records{substr( $input_record , 12 , 15 )} = $input_record ;
}
close( In ) ;

open( Out , $pdb_out ) or die ;
while( defined( $output_record = <Out> ) ) {
  next unless( $output_record =~ /^ATOM/ ) ;
  next if( substr( $output_record , 12 , 4 ) eq ' HN ' ) ;
  $output_record =~ s/CYX/CYS/ ; 

  # what the f*** has Richard done? - seems to put a '1' in column after chainID if altLoc was originally flagged.
  # then all altLocs are flagged - bloody marvelous
  if( substr( $output_record , 22 , 1 ) eq ' ' ) {
    substr( $output_record , 26 , 1 ) = ' ' ;
  } else {
    substr( $output_record , 22 , 1 ) = ' ' ;
    if( substr( $output_record , 23 , 1 ) eq '0' ) {
      substr( $output_record , 23 , 1 ) = ' ' ;
    }
    if( substr( $output_record , 24 , 1 ) eq '0' ) {
      substr( $output_record , 24 , 1 ) = ' ' ;
    }
  }
  if( defined( $atom_records{substr( $output_record , 12 , 15 )} ) ) {
    $atom_records{substr( $output_record , 12 , 15 )} = $output_record ;
  }

}
close( Out ) ;

#############
#

open( Out , "> $pdb_out" ) or die ;
open( Out_s , "> static_half.pdb" ) or die ;
open( Out_m , "> mobile_half.pdb" ) or die ;

open( In  , "static_part_on_output.pdb" ) or die ;
while( defined( $input_record = <In> ) ) {
  if( $input_record =~ /^ATOM/ ) {
    $record = $atom_records{substr( $input_record , 12 , 15 )} ;
    $record = substr( $record , 0 , 54 ) ;
    $record = $record."  0.00  0.00\n" ;
    print Out $record ;
    print Out_s $record ;
  } else {
    print Out $input_record ;
    print Out_s $input_record ;
  }
}
close( In ) ;
open( In  , "mobile_part_on_output.pdb" ) or die ;
while( defined( $input_record = <In> ) ) {
  if( $input_record =~ /^ATOM/ ) {
    $record = $atom_records{substr( $input_record , 12 , 15 )} ;
    $record = substr( $record , 0 , 54 ) ;
    $record = $record."  0.00  0.00\n" ;
    print Out $record ;
    print Out_m $record ;
  } else {
    print Out $input_record ;
    print Out_m $input_record ;
  }
}
close( In ) ;
close( Out ) ;
close( Out_s ) ;
close( Out_m ) ;

system "rm -f static_part.pdb mobile_part.pdb static_output.pdb mobile_output.pdb profit.com static_part_on_output.pdb mobile_part_on_output.pdb ${pdb_out}.*" ;
system "/bin/rm -f PDB PDB1 PDB2 PDBtor TOR.DAT INTERNAL.DAT" ;

exit ;
